#!perl

#!***********************************************************************
#!
#! AdjSpline
#!
#! Created by Bruce A. Atkinson  8/12/99
#!
#! Using ActivePerl
#!
#! Purpose:
#!
#!   To take a spline created with MCMSplineEdit and make it work with
#!   either a track enlarged with a different Grid Resolution or a track
#!   made larger then the center 1x1 grid ie BAJA
#!
#!
#!***********************************************************************

if ($ARGV[1] eq "")
{
    print "Usage: adjspline NewGridRes SplineToAdjust [-quarry|-nat [GridSize]]\n";
    exit(0);
}

#! Get the command line paramaters

$NewGridRes = $ARGV[0];
$SplineFile = $ARGV[1];
$GridType =   $ARGV[2];
$NumGrids =   $ARGV[3];

#! Set some constant values

$NatSize = 1280;
$QuarrySize = 1792;

#! Is it a quarry or a national default to national

if (substr($GridType,0,2) eq "-q")
{
    $GridSize = $QuarrySize;
}
else
{
    $GridSize = $NatSize;
}

#! Is there more than one grid to worry about

if ($NumGrids eq "")
{
    $NumGrids = 1.0;
}
else
{
    $NumGrids = $NumGrids * 1.0;
}

#! Set the scale that we are dealing with. It's a combination of 
#! Grid resoltion and number of grids.

$Scale = ($NewGridRes * $NumGrids) / 3.0; #!OldGridRes

#! Set the offset it should be zero if the Grid Resolution is 3.0
#! The number of grids isn't a factor (At least I hope it isn't)

$Offset = (($GridSize * ($NewGridRes / 3.0)) - $GridSize) / 2;

#! process the spline text file

open (SplineFILE, "<$SplineFile") || die "Error opening Spline file $!";

$NumPointLine = 1;

while(<SplineFILE>)
{
    if ($NumPointLine eq 1)
    {
        #! Skip first line
        
        $NumPointLine = 0;
        print $_;
    }
    else
    {
        #! seperate all the data items
        
        ($x,$y,$w,$pttype) = split(",");
        
        #! Get rid of the carriage return
        
        chomp($pttype);
        
        #! Scale the X and add the Offset.  If this is multiple grids and Grid
        #! Resolution is 3.0 then Offset should be 0.

        $x = $x * $Scale + $Offset;
        
        #! Do the same for Y
        
        $y = $y * $Scale + $Offset;
        
        #! Only Scale up the width. The offset isn't a factor
        
        $w = $w * $Scale;
        
        #! print out the adjusted values for redirection to inputfile.ADJ

        printf "%f,%f,%f,%d\n", $x,$y,$w,$pttype;
    }
}

#! close the file

close (SplineFILE);

#! All Done
