#!perl

#!***********************************************************************
#!
#! ASCStats
#!
#! Created by Bruce A. Atkinson  8/12/99
#!
#! Using ActivePerl
#!
#! Purpose:
#!
#!   To display some statistics about an ASC file.           
#!
#!***********************************************************************

if ($ARGV[0] eq "")
{
	print "\nUsage: ASCStats ASCFile.asc\n";
	print "\n";
	exit(0);
}


open (ASCFILE, "<$ARGV[0]") || die "Error opening ASC file $!";

$XVal = 0;
$YVal = 0;
$ZVal = 0;

$MinX = 9999;
$MaxX = -9999;

$MinY = 9999;
$MaxY = -9999;

$MinZ = 9999;
$MaxZ = -9999;

while (<ASCFILE>)
{
	if (/Z:/)
    {
    	($p1,$p2,$p3,$XVal,$p5,$YVal,$p6,$ZVal) = split(" ");
    	chomp($ZVal);

        if ($XVal < $MinX)
        {
        	$MinX = $XVal;
        }
	
        if ($YVal < $MinY)
        {
        	$MinY = $YVal;
        }
	
        if ($ZVal < $MinZ)
        {
        	$MinZ = $ZVal;
        }

        if ($XVal > $MaxX)
        {
        	$MaxX = $XVal;
        }
	
        if ($YVal > $MaxY)
        {
        	$MaxY = $YVal;
        }
	
        if ($ZVal > $MaxZ)
        {
        	$MaxZ = $ZVal;
        }

    }

}

print "\nASCStats for $ARGV[0]:\n\n";
print "    Min X = ",$MinX,"\n";
print "    Max X = ",$MaxX,"\n";
print "    Min Y = ",$MinY,"\n";
print "    Max Y = ",$MaxY,"\n";
print "    Min Z = ",$MinZ,"\n";
print "    Max Z = ",$MaxZ,"\n";


close(ASCFILE);
